<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class YarnApplication extends \Google\Model
{
  /**
   * @var string
   */
  public $memoryMbSeconds;
  /**
   * @var string
   */
  public $name;
  /**
   * @var float
   */
  public $progress;
  /**
   * @var string
   */
  public $state;
  /**
   * @var string
   */
  public $trackingUrl;
  /**
   * @var string
   */
  public $vcoreSeconds;

  /**
   * @param string
   */
  public function setMemoryMbSeconds($memoryMbSeconds)
  {
    $this->memoryMbSeconds = $memoryMbSeconds;
  }
  /**
   * @return string
   */
  public function getMemoryMbSeconds()
  {
    return $this->memoryMbSeconds;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param float
   */
  public function setProgress($progress)
  {
    $this->progress = $progress;
  }
  /**
   * @return float
   */
  public function getProgress()
  {
    return $this->progress;
  }
  /**
   * @param string
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * @param string
   */
  public function setTrackingUrl($trackingUrl)
  {
    $this->trackingUrl = $trackingUrl;
  }
  /**
   * @return string
   */
  public function getTrackingUrl()
  {
    return $this->trackingUrl;
  }
  /**
   * @param string
   */
  public function setVcoreSeconds($vcoreSeconds)
  {
    $this->vcoreSeconds = $vcoreSeconds;
  }
  /**
   * @return string
   */
  public function getVcoreSeconds()
  {
    return $this->vcoreSeconds;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(YarnApplication::class, 'Google_Service_Dataproc_YarnApplication');
